package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.common.ValidationHelper;
import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.List;

import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="Location",schema="hib")
public class Location extends ReferenceObject implements Comparable {
	
	public static Location findById(final int locationId) throws ObjectNotFoundException {
		return DartObjectFactory.getInstance().getLocationDAO().findById(locationId);
	}
	
	public static List<Location> listAll() {
		return DartObjectFactory.getInstance().getLocationDAO().listAll();
	}
	
	public static Location findByName(final String name) throws ObjectNotFoundException, ValidationException {
		ValidationHelper.required("Location Name", name);
		ValidationHelper.validateSize("Location Name", name, 1, 64);
		
		return DartObjectFactory.getInstance().getLocationDAO().findByName(name);
	}
	
	// necessary to use (List<Location>).contains()
	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		
		if ((obj instanceof Location) == false) {
			return false;
		}
		
		Location rs2 = (Location)obj;
		return rs2.getId() == this.getId();
	}
	
	@Override public int hashCode() {
        return this.id;
    }

	@Override
	public int compareTo(Object o) {
		if (o == null) {
			return -1;
		}
		if (Location.class.isAssignableFrom(o.getClass()) == false) {
			return -1;
		}
		
		Location loc2 = (Location)o;
		if (getName() == null) {
			return loc2.getName() == null ? 0 : -1;
		}

		return getName().compareTo(loc2.getName());
	}
}